<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\BinaryAuthorization;

class VulnerabilityCheck extends \Google\Collection
{
  /**
   * Not specified.
   */
  public const MAXIMUM_FIXABLE_SEVERITY_MAXIMUM_ALLOWED_SEVERITY_UNSPECIFIED = 'MAXIMUM_ALLOWED_SEVERITY_UNSPECIFIED';
  /**
   * Block any vulnerability.
   */
  public const MAXIMUM_FIXABLE_SEVERITY_BLOCK_ALL = 'BLOCK_ALL';
  /**
   * Allow only minimal severity.
   */
  public const MAXIMUM_FIXABLE_SEVERITY_MINIMAL = 'MINIMAL';
  /**
   * Allow only low severity and lower.
   */
  public const MAXIMUM_FIXABLE_SEVERITY_LOW = 'LOW';
  /**
   * Allow medium severity and lower.
   */
  public const MAXIMUM_FIXABLE_SEVERITY_MEDIUM = 'MEDIUM';
  /**
   * Allow high severity and lower.
   */
  public const MAXIMUM_FIXABLE_SEVERITY_HIGH = 'HIGH';
  /**
   * Allow critical severity and lower.
   */
  public const MAXIMUM_FIXABLE_SEVERITY_CRITICAL = 'CRITICAL';
  /**
   * Allow all severity, even vulnerability with unspecified severity.
   */
  public const MAXIMUM_FIXABLE_SEVERITY_ALLOW_ALL = 'ALLOW_ALL';
  /**
   * Not specified.
   */
  public const MAXIMUM_UNFIXABLE_SEVERITY_MAXIMUM_ALLOWED_SEVERITY_UNSPECIFIED = 'MAXIMUM_ALLOWED_SEVERITY_UNSPECIFIED';
  /**
   * Block any vulnerability.
   */
  public const MAXIMUM_UNFIXABLE_SEVERITY_BLOCK_ALL = 'BLOCK_ALL';
  /**
   * Allow only minimal severity.
   */
  public const MAXIMUM_UNFIXABLE_SEVERITY_MINIMAL = 'MINIMAL';
  /**
   * Allow only low severity and lower.
   */
  public const MAXIMUM_UNFIXABLE_SEVERITY_LOW = 'LOW';
  /**
   * Allow medium severity and lower.
   */
  public const MAXIMUM_UNFIXABLE_SEVERITY_MEDIUM = 'MEDIUM';
  /**
   * Allow high severity and lower.
   */
  public const MAXIMUM_UNFIXABLE_SEVERITY_HIGH = 'HIGH';
  /**
   * Allow critical severity and lower.
   */
  public const MAXIMUM_UNFIXABLE_SEVERITY_CRITICAL = 'CRITICAL';
  /**
   * Allow all severity, even vulnerability with unspecified severity.
   */
  public const MAXIMUM_UNFIXABLE_SEVERITY_ALLOW_ALL = 'ALLOW_ALL';
  protected $collection_key = 'containerAnalysisVulnerabilityProjects';
  /**
   * Optional. A list of specific CVEs to ignore even if the vulnerability level
   * violates `maximumUnfixableSeverity` or `maximumFixableSeverity`. CVEs are
   * listed in the format of Container Analysis note id. For example: -
   * CVE-2021-20305 - CVE-2020-10543 The CVEs are applicable regardless of note
   * provider project, e.g., an entry of `CVE-2021-20305` will allow
   * vulnerabilities with a note name of either `projects/goog-
   * vulnz/notes/CVE-2021-20305` or `projects/CUSTOM-
   * PROJECT/notes/CVE-2021-20305`.
   *
   * @var string[]
   */
  public $allowedCves;
  /**
   * Optional. A list of specific CVEs to always raise warnings about even if
   * the vulnerability level meets `maximumUnfixableSeverity` or
   * `maximumFixableSeverity`. CVEs are listed in the format of Container
   * Analysis note id. For example: - CVE-2021-20305 - CVE-2020-10543 The CVEs
   * are applicable regardless of note provider project, e.g., an entry of
   * `CVE-2021-20305` will block vulnerabilities with a note name of either
   * `projects/goog-vulnz/notes/CVE-2021-20305` or `projects/CUSTOM-
   * PROJECT/notes/CVE-2021-20305`.
   *
   * @var string[]
   */
  public $blockedCves;
  /**
   * Optional. The projects where vulnerabilities are stored as Container
   * Analysis Occurrences. Each project is expressed in the resource format of
   * `projects/[PROJECT_ID]`, e.g., `projects/my-gcp-project`. An attempt will
   * be made for each project to fetch vulnerabilities, and all valid
   * vulnerabilities will be used to check against the vulnerability policy. If
   * no valid scan is found in all projects configured here, an error will be
   * returned for the check. Maximum number of
   * `container_analysis_vulnerability_projects` allowed in each
   * `VulnerabilityCheck` is 10.
   *
   * @var string[]
   */
  public $containerAnalysisVulnerabilityProjects;
  /**
   * Required. The threshold for severity for which a fix is currently
   * available. This field is required and must be set.
   *
   * @var string
   */
  public $maximumFixableSeverity;
  /**
   * Required. The threshold for severity for which a fix isn't currently
   * available. This field is required and must be set.
   *
   * @var string
   */
  public $maximumUnfixableSeverity;

  /**
   * Optional. A list of specific CVEs to ignore even if the vulnerability level
   * violates `maximumUnfixableSeverity` or `maximumFixableSeverity`. CVEs are
   * listed in the format of Container Analysis note id. For example: -
   * CVE-2021-20305 - CVE-2020-10543 The CVEs are applicable regardless of note
   * provider project, e.g., an entry of `CVE-2021-20305` will allow
   * vulnerabilities with a note name of either `projects/goog-
   * vulnz/notes/CVE-2021-20305` or `projects/CUSTOM-
   * PROJECT/notes/CVE-2021-20305`.
   *
   * @param string[] $allowedCves
   */
  public function setAllowedCves($allowedCves)
  {
    $this->allowedCves = $allowedCves;
  }
  /**
   * @return string[]
   */
  public function getAllowedCves()
  {
    return $this->allowedCves;
  }
  /**
   * Optional. A list of specific CVEs to always raise warnings about even if
   * the vulnerability level meets `maximumUnfixableSeverity` or
   * `maximumFixableSeverity`. CVEs are listed in the format of Container
   * Analysis note id. For example: - CVE-2021-20305 - CVE-2020-10543 The CVEs
   * are applicable regardless of note provider project, e.g., an entry of
   * `CVE-2021-20305` will block vulnerabilities with a note name of either
   * `projects/goog-vulnz/notes/CVE-2021-20305` or `projects/CUSTOM-
   * PROJECT/notes/CVE-2021-20305`.
   *
   * @param string[] $blockedCves
   */
  public function setBlockedCves($blockedCves)
  {
    $this->blockedCves = $blockedCves;
  }
  /**
   * @return string[]
   */
  public function getBlockedCves()
  {
    return $this->blockedCves;
  }
  /**
   * Optional. The projects where vulnerabilities are stored as Container
   * Analysis Occurrences. Each project is expressed in the resource format of
   * `projects/[PROJECT_ID]`, e.g., `projects/my-gcp-project`. An attempt will
   * be made for each project to fetch vulnerabilities, and all valid
   * vulnerabilities will be used to check against the vulnerability policy. If
   * no valid scan is found in all projects configured here, an error will be
   * returned for the check. Maximum number of
   * `container_analysis_vulnerability_projects` allowed in each
   * `VulnerabilityCheck` is 10.
   *
   * @param string[] $containerAnalysisVulnerabilityProjects
   */
  public function setContainerAnalysisVulnerabilityProjects($containerAnalysisVulnerabilityProjects)
  {
    $this->containerAnalysisVulnerabilityProjects = $containerAnalysisVulnerabilityProjects;
  }
  /**
   * @return string[]
   */
  public function getContainerAnalysisVulnerabilityProjects()
  {
    return $this->containerAnalysisVulnerabilityProjects;
  }
  /**
   * Required. The threshold for severity for which a fix is currently
   * available. This field is required and must be set.
   *
   * Accepted values: MAXIMUM_ALLOWED_SEVERITY_UNSPECIFIED, BLOCK_ALL, MINIMAL,
   * LOW, MEDIUM, HIGH, CRITICAL, ALLOW_ALL
   *
   * @param self::MAXIMUM_FIXABLE_SEVERITY_* $maximumFixableSeverity
   */
  public function setMaximumFixableSeverity($maximumFixableSeverity)
  {
    $this->maximumFixableSeverity = $maximumFixableSeverity;
  }
  /**
   * @return self::MAXIMUM_FIXABLE_SEVERITY_*
   */
  public function getMaximumFixableSeverity()
  {
    return $this->maximumFixableSeverity;
  }
  /**
   * Required. The threshold for severity for which a fix isn't currently
   * available. This field is required and must be set.
   *
   * Accepted values: MAXIMUM_ALLOWED_SEVERITY_UNSPECIFIED, BLOCK_ALL, MINIMAL,
   * LOW, MEDIUM, HIGH, CRITICAL, ALLOW_ALL
   *
   * @param self::MAXIMUM_UNFIXABLE_SEVERITY_* $maximumUnfixableSeverity
   */
  public function setMaximumUnfixableSeverity($maximumUnfixableSeverity)
  {
    $this->maximumUnfixableSeverity = $maximumUnfixableSeverity;
  }
  /**
   * @return self::MAXIMUM_UNFIXABLE_SEVERITY_*
   */
  public function getMaximumUnfixableSeverity()
  {
    return $this->maximumUnfixableSeverity;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(VulnerabilityCheck::class, 'Google_Service_BinaryAuthorization_VulnerabilityCheck');
