<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudSecurityToken;

class GoogleIdentityStsV1AccessBoundary extends \Google\Collection
{
  protected $collection_key = 'accessBoundaryRules';
  protected $accessBoundaryRulesType = GoogleIdentityStsV1AccessBoundaryRule::class;
  protected $accessBoundaryRulesDataType = 'array';

  /**
   * A list of access boundary rules which defines the upper bound of the
   * permission a principal may carry. If multiple rules are specified, the
   * effective access boundary is the union of all the access boundary rules
   * attached. One access boundary can contain at most 10 rules.
   *
   * @param GoogleIdentityStsV1AccessBoundaryRule[] $accessBoundaryRules
   */
  public function setAccessBoundaryRules($accessBoundaryRules)
  {
    $this->accessBoundaryRules = $accessBoundaryRules;
  }
  /**
   * @return GoogleIdentityStsV1AccessBoundaryRule[]
   */
  public function getAccessBoundaryRules()
  {
    return $this->accessBoundaryRules;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleIdentityStsV1AccessBoundary::class, 'Google_Service_CloudSecurityToken_GoogleIdentityStsV1AccessBoundary');
