<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Games;

class GamePlayerToken extends \Google\Model
{
  /**
   * The application that this player identifier is for.
   *
   * @var string
   */
  public $applicationId;
  protected $recallTokenType = RecallToken::class;
  protected $recallTokenDataType = '';

  /**
   * The application that this player identifier is for.
   *
   * @param string $applicationId
   */
  public function setApplicationId($applicationId)
  {
    $this->applicationId = $applicationId;
  }
  /**
   * @return string
   */
  public function getApplicationId()
  {
    return $this->applicationId;
  }
  /**
   * Recall token data.
   *
   * @param RecallToken $recallToken
   */
  public function setRecallToken(RecallToken $recallToken)
  {
    $this->recallToken = $recallToken;
  }
  /**
   * @return RecallToken
   */
  public function getRecallToken()
  {
    return $this->recallToken;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GamePlayerToken::class, 'Google_Service_Games_GamePlayerToken');
