<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ShoppingContent;

class ShoppingAdsProgramStatusReviewIneligibilityReasonDetails extends \Google\Model
{
  /**
   * This timestamp represents end of cooldown period for review ineligbility
   * reason `IN_COOLDOWN_PERIOD`.
   *
   * @var string
   */
  public $cooldownTime;

  /**
   * This timestamp represents end of cooldown period for review ineligbility
   * reason `IN_COOLDOWN_PERIOD`.
   *
   * @param string $cooldownTime
   */
  public function setCooldownTime($cooldownTime)
  {
    $this->cooldownTime = $cooldownTime;
  }
  /**
   * @return string
   */
  public function getCooldownTime()
  {
    return $this->cooldownTime;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ShoppingAdsProgramStatusReviewIneligibilityReasonDetails::class, 'Google_Service_ShoppingContent_ShoppingAdsProgramStatusReviewIneligibilityReasonDetails');
